// Recursively visit all meshes in the hierarchy
function visitAllMeshes(mesh, func) {
    for (var i = 0; i < mesh.childMeshCount(); i++) {
        var child = mesh.getChildMeshAtIndex(i);
        visitAllMeshes(child, func);
        mesh.setChildMeshAtIndex(i, child);
    }
    func(mesh);
}

// Add greebles to a mesh along its path edges
function addGreeblesToMesh(mesh) {
    var pathCount = mesh.count();
    for (var p = 0; p < pathCount; p++) {
        var path = mesh.getPathAtIndex(p);
        if (!path || path.empty()) {
            continue;
        }

        var pathLen = path.length();
        if (pathLen <= 0) {
            continue;
        }

        for (var i = 0; i < count; i++) {
            // Sample position along path (evenly distributed)
            var t = i / count;
            var pos = path.pointAtParam(t);
            var normal = path.normalAtParam(t);
            var angle = path.angleAtParam(t);

            // Get falloff value at this position (includes strength)
            var falloff = def.getFalloffAtPoint(pos.x, pos.y);
            if (falloff <= 0) {
                continue;
            }

            // Random dimensions scaled by falloff
            var w = cavalry.random(minWidth, maxWidth, seed, i * 3) * falloff;
            var h = cavalry.random(minHeight, maxHeight, seed, i * 3 + 1) * falloff;
            var rot = cavalry.random(-rotation, rotation, seed, i * 3 + 2);

            // Position with normal offset
            var gx = pos.x + normal.x * normalOffset;
            var gy = pos.y + normal.y * normalOffset;

            // Create greeble rectangle centred at origin
            var greeblePath = new cavalry.Path();
            greeblePath.addRect(-w / 2, -h / 2, w / 2, h / 2);

            // Apply rotation: angle is tangent direction
            // Then apply random rotation variation
            greeblePath.rotate(angle + rot);
            greeblePath.translate(gx, gy);

            // Add greeble to mesh (inherits material from parent)
            mesh.addPath(greeblePath);
        }
    }
}

// Get root mesh, process all meshes, then set it back
var root = def.getRootMesh();
visitAllMeshes(root, addGreeblesToMesh);
def.setRootMesh(root);
